/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Publisher;
import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.BooleanSupplier;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;

public final class FlowableRepeatUntil<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BooleanSupplier until;

    public FlowableRepeatUntil(Flowable<T> source, BooleanSupplier until) {
        super(source);
        this.until = until;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter(false);
        s.onSubscribe(sa);
        RepeatSubscriber<T> rs = new RepeatSubscriber<T>(s, this.until, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> downstream;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final BooleanSupplier stop;
        long produced;

        RepeatSubscriber(Subscriber<? super T> actual, BooleanSupplier until, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.downstream = actual;
            this.sa = sa;
            this.source = source;
            this.stop = until;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            boolean b;
            try {
                b = this.stop.getAsBoolean();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(e);
                return;
            }
            if (b) {
                this.downstream.onComplete();
            } else {
                this.subscribeNext();
            }
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

